unit UnitHttp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AXmsCtrl_TLB, ShellAPI;

type
  TFormHttp = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    EditHost: TEdit;
    EditURLText: TEdit;
    EditURLUnicode: TEdit;
    EditSuccessResponse: TEdit;
    EditErrorResponse: TEdit;
    Label6: TLabel;
    EditPort: TEdit;
    GroupBox2: TGroupBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    EditRecipient: TEdit;
    EditSender: TEdit;
    ComboType: TComboBox;
    EditMessage: TMemo;
    ButtonSend: TButton;
    GroupBox3: TGroupBox;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    EditResult: TEdit;
    EditResponse: TEdit;
    ButtonView: TButton;
    EditLogfile: TEdit;
    function GetTempDirectory ()  : String;
    function GetResult ()         : Integer;
    procedure ButtonSendClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonViewClick(Sender: TObject);
  private
    objHttp    : ISmsProtocolHttp;
    objMessage : ISmsMessage;
  public
    { Public declarations }
  end;

var
  FormHttp: TFormHttp;

implementation

{$R *.dfm}

{//////////////////////////////////////////////////////////////////////////////}

procedure TFormHttp.ButtonSendClick(Sender: TObject);
var vtVar : OleVariant;
begin
  objHttp.Clear ();

  objHttp.LogFile                 := EditLogfile.Text;
  
  objHttp.ProviderHost            := EditHost.Text;
  objHttp.ProviderPort            := StrToInt ( EditPort.Text );
  objHttp.ProviderSuccessResponse := EditSuccessResponse.Text;
  objHttp.ProviderErrorResponse   := EditErrorResponse.Text;
  objHttp.URLText                 := EditURLText.Text;
  objHttp.URLUnicode              := EditURLUnicode.Text;

  objMessage.Recipient            := EditRecipient.Text;
  objMessage.Sender               := EditSender.Text;
  objMessage.Format               := ComboType.ItemIndex;
  objMessage.Data                 := EditMessage.Text;

  vtVar := objMessage;

  Screen.Cursor := crHourGlass;
  objHttp.Send ( vtVar );
  Screen.Cursor := crDefault;

  GetResult ();
end;

{//////////////////////////////////////////////////////////////////////////////}

procedure TFormHttp.FormCreate(Sender: TObject);
begin
  objHttp    := TSmsProtocolHttp.Create(Application).DefaultInterface;
  objMessage := TSmsMessage.Create(Application).DefaultInterface;

  ComboType.Items.Add ( 'Text' );
  ComboType.Items.Add ( 'Unicode' );

  ComboType.ItemIndex := 0;

  GetTempDirectory ();
end;

{//////////////////////////////////////////////////////////////////////////////}

procedure TFormHttp.ButtonViewClick(Sender: TObject);
var LogFile : PAnsiChar;
begin
  LogFile := StrNew(PChar(EditLogfile.Text));

  ShellExecute ( 0, 'open' , LogFile, '', '', SW_SHOW )
end;

{//////////////////////////////////////////////////////////////////////////////}

function TFormHttp.GetTempDirectory () : String;
var Buffer : array [0..MAX_PATH] of Char;
begin
  GetTempPath ( MAX_PATH, Buffer );
  EditLogfile.Text := StrPas ( Buffer ) + 'HttpLog.txt';
end;

{////////////////////////////////////////////////////////////////////////////////}

function TFormHttp.GetResult () : Integer;
begin
  Result := objHttp.LastError;

  EditResponse.Text := objHttp.ProviderResponse;
  EditResult.Text := IntToStr ( Result ) + ' : ' + objHttp.GetErrorDescription( Result );
end;

{////////////////////////////////////////////////////////////////////////////////}

end.
